/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.s3;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awss3bucket")
public class S3Bucket
extends AWSResource {
    protected static final String TABLE_NAME = "awss3bucket";
    public static final String RESOURCE_TYPE = "AWS::S3::Bucket";

    public S3Bucket() {
        this.resourceType = RESOURCE_TYPE;
    }

    public S3Bucket(String account, String region, Bucket bucket) {
        this.awsAccountId = account;
        this.awsRegion = region;
        this.arn = "arn:aws:s3:::" + bucket.name();
        this.resourceName = bucket.name();
        this.resourceId = bucket.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{bucket});
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = bucket.creationDate();
    }
}

