/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.route53;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsroute53hostedzone")
public class Route53HostedZone
extends AWSResource {
    protected static final String TABLE_NAME = "awsroute53hostedzone";
    public static final String RESOURCE_TYPE = "AWS::Route53::HostedZone";

    public Route53HostedZone() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Route53HostedZone(String account, String regionId, HostedZone hostedZone) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.resourceId = hostedZone.id();
        this.arn = String.format("arn:aws:route53:::hostedZone/%s", hostedZone.id());
        this.resourceName = hostedZone.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{hostedZone});
        this.resourceType = RESOURCE_TYPE;
    }
}

