/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.rds;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.rds.model.DBProxy;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsrdsproxy")
public class RDSProxy
extends AWSResource {
    protected static final String TABLE_NAME = "awsrdsproxy";
    public static final String RESOURCE_TYPE = "AWS::RDS::DBProxy";

    public RDSProxy() {
        this.resourceType = RESOURCE_TYPE;
    }

    public RDSProxy(String account, String regionId, DBProxy dbProxy) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = dbProxy.dbProxyArn();
        this.resourceId = dbProxy.dbProxyArn();
        this.resourceName = dbProxy.dbProxyName();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{dbProxy});
        this.createdIso = dbProxy.createdDate();
    }
}

