/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.lightsail;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.lightsail.model.LoadBalancer;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awslightsailloadbalancer")
public class LightsailLoadBalancer
extends AWSResource {
    protected static final String TABLE_NAME = "awslightsailloadbalancer";
    public static final String RESOURCE_TYPE = "AWS::Lightsail::LoadBalancer";

    public LightsailLoadBalancer() {
        this.resourceType = RESOURCE_TYPE;
    }

    public LightsailLoadBalancer(String account, String regionId, LoadBalancer loadBalancer) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = loadBalancer.arn();
        this.resourceName = loadBalancer.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{loadBalancer});
        this.resourceType = RESOURCE_TYPE;
    }
}

