/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.lightsail;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabase;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awslightsaildatabase")
public class LightsailDatabase
extends AWSResource {
    protected static final String TABLE_NAME = "awslightsaildatabase";
    public static final String RESOURCE_TYPE = "AWS::Lightsail::Database";

    public LightsailDatabase() {
        this.resourceType = RESOURCE_TYPE;
    }

    public LightsailDatabase(String account, String regionId, RelationalDatabase database) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = database.arn();
        this.resourceName = database.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{database});
        this.resourceType = RESOURCE_TYPE;
    }
}

