/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.lambda;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import java.time.Instant;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awslambdafunction")
public class LambdaFunction
extends AWSResource {
    protected static final String TABLE_NAME = "awslambdafunction";
    public static final String RESOURCE_TYPE = "AWS::Lambda::Function";

    public LambdaFunction() {
        this.resourceType = RESOURCE_TYPE;
    }

    public LambdaFunction(String account, String regionId, FunctionConfiguration function) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = function.functionArn();
        this.resourceId = function.revisionId();
        this.resourceName = function.functionName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{function});
        this.resourceType = RESOURCE_TYPE;
        this.updatedIso = Instant.parse(function.lastModified());
    }
}

