/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.fsx;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.fsx.model.FileSystem;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsfsxfilesystem")
public class FSxFileSystem
extends AWSResource {
    protected static final String TABLE_NAME = "awsfsxfilesystem";
    public static final String RESOURCE_TYPE = "AWS::FSx::FileSystem";

    public FSxFileSystem() {
        this.resourceType = RESOURCE_TYPE;
    }

    public FSxFileSystem(String account, String regionId, FileSystem fileSystem) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = fileSystem.resourceARN();
        this.resourceId = fileSystem.fileSystemId();
        this.resourceName = fileSystem.fileSystemId();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{fileSystem});
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = fileSystem.creationTime();
    }

    public FSxFileSystem(String account, String regionId, FileSystem fileSystem, ObjectMapper objectMapper) {
        this(account, regionId, fileSystem);
        this.tags = (JsonNode)objectMapper.convertValue(fileSystem.tags().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
    }
}

