/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.elb;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awselasticloadbalancingloadbalancer")
public class ElasticLoadBalancingLoadBalancer
extends AWSResource {
    protected static final String TABLE_NAME = "awselasticloadbalancingloadbalancer";
    public static final String RESOURCE_TYPE = "AWS::ElasticLoadBalancing::LoadBalancer";
    private static final String ARN_FORMAT = "arn:aws:elasticloadbalancing:%s:%s:loadbalancer/%s";

    public ElasticLoadBalancingLoadBalancer() {
        this.resourceType = RESOURCE_TYPE;
    }

    public ElasticLoadBalancingLoadBalancer(LoadBalancerDescription loadBalancer, String region, String accountId) {
        this.resourceName = loadBalancer.dnsName();
        this.resourceId = loadBalancer.loadBalancerName();
        this.awsRegion = region;
        this.awsAccountId = accountId;
        this.resourceType = RESOURCE_TYPE;
        this.arn = String.format(ARN_FORMAT, region, accountId, loadBalancer.loadBalancerName());
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{loadBalancer});
        this.createdIso = loadBalancer.createdTime();
    }
}

