/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.eks;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.eks.model.Cluster;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsekscluster")
public class EksCluster
extends AWSResource {
    protected static final String TABLE_NAME = "awsekscluster";
    public static final String RESOURCE_TYPE = "AWS::EKS::Cluster";

    public EksCluster() {
        this.resourceType = RESOURCE_TYPE;
    }

    public EksCluster(String account, String regionId, Cluster cluster) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = cluster.arn();
        this.resourceName = cluster.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{cluster});
        this.resourceType = RESOURCE_TYPE;
    }
}

