/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.ec2.model.Vpc;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2vpc")
public class Ec2VpcResource
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2vpc";
    public static final String RESOURCE_TYPE = "AWS::EC2::VPC";

    public Ec2VpcResource() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Ec2VpcResource(String accountId, String region, Vpc vpc) {
        this.arn = String.format("arn:aws:ec2:%s:%s:vpc/%s", region, accountId, vpc.vpcId());
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = vpc.vpcId();
        this.resourceName = vpc.vpcId();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{vpc});
    }
}

