/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.ec2.model.TransitGateway;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2transitgateway")
public class Ec2TransitGateway
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2transitgateway";
    public static final String RESOURCE_TYPE = "AWS::EC2::TransitGateway";

    public Ec2TransitGateway() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Ec2TransitGateway(String account, String region, TransitGateway transit) {
        this.awsRegion = region;
        this.awsAccountId = account;
        this.arn = String.format("arn:aws:ec2:%s:%s:transit-gateway/%s", region, account, transit.transitGatewayId());
        this.resourceName = transit.transitGatewayId();
        this.resourceId = transit.transitGatewayId();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{transit});
        this.resourceType = RESOURCE_TYPE;
    }
}

