/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2subnet")
public class Ec2Subnet
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2subnet";
    public static final String RESOURCE_TYPE = "AWS::EC2::Subnet";

    public Ec2Subnet() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Ec2Subnet(String accountId, String region, Subnet subnet) {
        this.arn = subnet.subnetArn();
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = subnet.subnetId();
        this.resourceName = subnet.subnetId();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{subnet});
    }
}

