/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.ec2.model.Address;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2eip")
public class Ec2ElasticIpAddress
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2eip";
    public static final String RESOURCE_TYPE = "AWS::EC2::EIP";

    public Ec2ElasticIpAddress() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Ec2ElasticIpAddress(String accountId, String region, Address address) {
        this.arn = String.format("arn:aws:ec2:%s:%s:eip-allocation/%s", region, accountId, address.allocationId());
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = address.allocationId();
        this.resourceName = address.publicIp();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{address});
    }
}

