/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.dynamodb;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsdynamodbglobaltable")
public class DynamoDbGlobalTable
extends AWSResource {
    protected static final String TABLE_NAME = "awsdynamodbglobaltable";
    public static final String RESOURCE_TYPE = "AWS::DynamoDB::GlobalTable";

    public DynamoDbGlobalTable() {
        this.resourceType = RESOURCE_TYPE;
    }

    public DynamoDbGlobalTable(String account, String region, GlobalTableDescription table) {
        this.awsAccountId = account;
        this.awsRegion = region;
        this.resourceName = table.globalTableName();
        this.resourceId = table.globalTableName();
        this.arn = table.globalTableArn();
        this.createdIso = table.creationDateTime();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{table});
        this.resourceType = RESOURCE_TYPE;
    }
}

