/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.cloudwatch;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import java.time.Instant;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awswatchloggroup")
public class CloudWatchLogGroup
extends AWSResource {
    protected static final String TABLE_NAME = "awswatchloggroup";
    public static final String RESOURCE_TYPE = "AWS::CloudWatchLogs::LogGroup";

    public CloudWatchLogGroup() {
        this.resourceType = RESOURCE_TYPE;
    }

    public CloudWatchLogGroup(String accountId, String region, LogGroup logGroup) {
        this.resourceName = logGroup.logGroupName();
        this.arn = logGroup.arn();
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = logGroup.arn();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{logGroup});
        this.createdIso = Instant.ofEpochMilli(logGroup.creationTime());
    }
}

