/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.batch;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsbatchcomputeenvironment")
public class BatchComputeEnvironment
extends AWSResource {
    protected static final String TABLE_NAME = "awsbatchcomputeenvironment";
    public static final String RESOURCE_TYPE = "AWS::Batch::ComputeEnvironment";

    public BatchComputeEnvironment() {
        this.resourceType = RESOURCE_TYPE;
    }

    public BatchComputeEnvironment(String account, String regionId, ComputeEnvironmentDetail computeEnvironment) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = computeEnvironment.computeEnvironmentArn();
        this.resourceName = computeEnvironment.computeEnvironmentName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{computeEnvironment});
        this.resourceType = RESOURCE_TYPE;
    }
}

