/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.backup;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.backup.model.BackupPlansListMember;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsbackupbackupplan")
public class BackupPlan
extends AWSResource {
    protected static final String TABLE_NAME = "awsbackupbackupplan";
    public static final String RESOURCE_TYPE = "AWS::Backup::BackupPlan";

    public BackupPlan() {
        this.resourceType = RESOURCE_TYPE;
    }

    public BackupPlan(String accountId, String region, BackupPlansListMember backupPlanListMember) {
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{backupPlanListMember});
        this.resourceType = RESOURCE_TYPE;
        this.arn = backupPlanListMember.backupPlanArn();
        this.resourceName = backupPlanListMember.backupPlanName();
        this.resourceId = backupPlanListMember.backupPlanId();
        this.createdIso = backupPlanListMember.creationDate();
    }
}

