/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.accounts;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsiamuser")
public class IamUser
extends AWSResource {
    protected static final String TABLE_NAME = "awsiamuser";
    public static final String RESOURCE_TYPE = "AWS::IAM::User";

    public IamUser() {
        this.resourceType = RESOURCE_TYPE;
    }

    public IamUser(String accountId, String region, User user) {
        this.arn = user.arn();
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = user.userId();
        this.resourceName = user.userName();
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = user.createDate();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{user});
    }
}

