/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.accounts;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsiamgroup")
public class IamGroup
extends AWSResource {
    public static final String TABLE_NAME = "awsiamgroup";
    public static final String RESOURCE_TYPE = "AWS::IAM::Group";

    public IamGroup() {
        this.resourceType = RESOURCE_TYPE;
    }

    public IamGroup(String accountId, String region, Group group) {
        this.arn = group.arn();
        this.awsAccountId = accountId;
        this.awsRegion = Region.AWS_GLOBAL.id();
        this.resourceId = group.groupId();
        this.resourceName = group.groupName();
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = group.createDate();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{group});
    }
}

