/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.qldb;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.qldb.model.DescribeLedgerResponse;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsqldbledger")
public class QldbLedger
extends AWSResource {
    protected static final String TABLE_NAME = "awsqldbledger";
    public static final String RESOURCE_TYPE = "AWS::Qldb::Ledger";

    public QldbLedger() {
        this.resourceType = RESOURCE_TYPE;
    }

    public QldbLedger(String account, String regionId, DescribeLedgerResponse ledger) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = ledger.arn();
        this.resourceName = ledger.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{ledger});
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = ledger.creationDateTime();
    }
}

