/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.neptune;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.neptune.model.DBInstance;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsneptuneinstance")
public class NeptuneInstance
extends AWSResource {
    protected static final String TABLE_NAME = "awsneptuneinstance";
    public static final String RESOURCE_TYPE = "AWS::Neptune::Instance";

    public NeptuneInstance() {
        this.resourceType = RESOURCE_TYPE;
    }

    public NeptuneInstance(String account, String regionId, DBInstance instance) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = instance.dbInstanceArn();
        this.resourceName = instance.dbName();
        this.resourceId = instance.dbInstanceIdentifier();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{instance});
        this.resourceType = RESOURCE_TYPE;
    }
}

