/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.neptune;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.neptune.model.DBCluster;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsneptunecluster")
public class NeptuneCluster
extends AWSResource {
    protected static final String TABLE_NAME = "awsneptunecluster";
    public static final String RESOURCE_TYPE = "AWS::Neptune::Cluster";

    public NeptuneCluster() {
        this.resourceType = RESOURCE_TYPE;
    }

    public NeptuneCluster(String account, String regionId, DBCluster cluster) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = cluster.dbClusterArn();
        this.resourceName = cluster.databaseName();
        this.resourceId = cluster.dbClusterIdentifier();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{cluster});
        this.resourceType = RESOURCE_TYPE;
    }
}

