/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.lightsail;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.lightsail.model.Instance;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awslightsailinstance")
public class LightsailInstance
extends AWSResource {
    protected static final String TABLE_NAME = "awslightsailinstance";
    public static final String RESOURCE_TYPE = "AWS::Lightsail::Instance";

    public LightsailInstance() {
        this.resourceType = RESOURCE_TYPE;
    }

    public LightsailInstance(String account, String regionId, Instance instance) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = instance.arn();
        this.resourceName = instance.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{instance});
        this.resourceType = RESOURCE_TYPE;
    }
}

