/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.kms;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awskmskey")
public class KmsKey
extends AWSResource {
    protected static final String TABLE_NAME = "awskmskey";
    public static final String RESOURCE_TYPE = "AWS::Kms::Key";

    public KmsKey() {
        this.resourceType = RESOURCE_TYPE;
    }

    public KmsKey(String account, String regionId, KeyListEntry key) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = key.keyArn();
        this.resourceId = key.keyId();
        this.resourceName = key.toString();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{key});
        this.resourceType = RESOURCE_TYPE;
    }
}

