/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.elasticache;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awselasticachecluster")
public class ElastiCacheCluster
extends AWSResource {
    protected static final String TABLE_NAME = "awselasticachecluster";
    public static final String RESOURCE_TYPE = "AWS::ElastiCache::Cluster";

    public ElastiCacheCluster() {
        this.resourceType = RESOURCE_TYPE;
    }

    public ElastiCacheCluster(String account, String regionId, CacheCluster cluster) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = cluster.arn();
        this.resourceId = cluster.cacheClusterId();
        this.resourceName = cluster.cacheClusterId();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{cluster});
        this.resourceType = RESOURCE_TYPE;
    }
}

