/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import com.fasterxml.jackson.databind.node.NullNode;
import io.openraven.magpie.data.aws.AWSResource;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsregion")
public class RegionResource
extends AWSResource {
    protected static final String TABLE_NAME = "awsregion";
    public static final String RESOURCE_TYPE = "AWS::Region";

    public RegionResource() {
        this.resourceType = RESOURCE_TYPE;
    }

    public RegionResource(String accountId, Region region) {
        this.arn = String.format("arn:aws::%s:%s", region.id(), accountId);
        this.awsAccountId = accountId;
        this.awsRegion = region.id();
        this.resourceId = region.id();
        RegionMetadata metadata = region.metadata();
        if (metadata != null) {
            this.resourceName = metadata.description();
        }
        this.resourceType = RESOURCE_TYPE;
        this.configuration = NullNode.instance;
    }
}

