/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnection;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2vpcpeeringconnection")
public class Ec2VpcPeeringConnection
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2vpcpeeringconnection";
    public static final String RESOURCE_TYPE = "AWS::EC2::VPCPeeringConnection";

    public Ec2VpcPeeringConnection() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Ec2VpcPeeringConnection(String accountId, String region, VpcPeeringConnection vpcConnection) {
        this.arn = String.format("arn:aws:ec2:%s:%s:vpc-peering-connection/%s", region, accountId, vpcConnection.vpcPeeringConnectionId());
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = vpcConnection.vpcPeeringConnectionId();
        this.resourceName = vpcConnection.vpcPeeringConnectionId();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{vpcConnection});
    }
}

