/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.ec2.model.NetworkInterface;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2networkinterface")
public class Ec2NetworkInterface
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2networkinterface";
    public static final String RESOURCE_TYPE = "AWS::EC2::NetworkInterface";

    public Ec2NetworkInterface() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Ec2NetworkInterface(String accountId, String region, NetworkInterface networkInterface) {
        this.arn = String.format("arn:aws:ec2:%s:%s:network-interface/%s", region, accountId, networkInterface.networkInterfaceId());
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = networkInterface.networkInterfaceId();
        this.resourceName = networkInterface.networkInterfaceId();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{networkInterface});
    }
}

