/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2instance")
public class Ec2Instance
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2instance";
    public static final String RESOURCE_TYPE = "AWS::EC2::Instance";

    public Ec2Instance() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Ec2Instance(String accountId, String region, Instance instance, Reservation reservation) {
        this.resourceName = instance.instanceId();
        this.resourceId = instance.instanceId();
        this.awsRegion = region;
        this.awsAccountId = accountId;
        this.resourceType = RESOURCE_TYPE;
        this.arn = String.format("arn:aws:ec2:%s:%s:instance/%s", region, reservation.ownerId(), instance.instanceId());
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{instance});
        this.createdIso = instance.launchTime();
    }
}

