/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.cloudtrail;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.cloudtrail.model.TrailInfo;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awscloudtrailtrail")
public class CloudTrail
extends AWSResource {
    protected static final String TABLE_NAME = "awscloudtrailtrail";
    public static final String RESOURCE_TYPE = "AWS::CloudTrail::Trail";

    public CloudTrail() {
        this.resourceType = RESOURCE_TYPE;
    }

    public CloudTrail(String account, String regionId, TrailInfo resource) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = resource.trailARN();
        this.resourceName = resource.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{resource});
        this.resourceType = RESOURCE_TYPE;
    }
}

