/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.cassandra;

import io.openraven.magpie.data.aws.AWSResource;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awscassandrakeyspace")
public class CassandraKeyspace
extends AWSResource {
    protected static final String TABLE_NAME = "awscassandrakeyspace";
    public static final String RESOURCE_TYPE = "AWS::Cassandra::Keyspace";

    public CassandraKeyspace() {
        this.resourceType = RESOURCE_TYPE;
    }

    public CassandraKeyspace(String regionId, String keyspaceName) {
        this.awsRegion = regionId;
        this.arn = String.format("arn:aws:cassandra:keyspace:%s::%s", regionId, keyspaceName);
        this.resourceId = keyspaceName;
        this.resourceName = keyspaceName;
        this.resourceType = RESOURCE_TYPE;
    }
}

