/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.batch;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.batch.model.JobDefinition;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsbatchjobdefinition")
public class BatchJobDefinition
extends AWSResource {
    protected static final String TABLE_NAME = "awsbatchjobdefinition";
    public static final String RESOURCE_TYPE = "AWS::Batch::JobDefinition";

    public BatchJobDefinition() {
        this.resourceType = RESOURCE_TYPE;
    }

    public BatchJobDefinition(String account, String regionId, JobDefinition jobDefinition) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = jobDefinition.jobDefinitionArn();
        this.resourceName = jobDefinition.jobDefinitionName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{jobDefinition});
        this.resourceType = RESOURCE_TYPE;
    }
}

