/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.accounts;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.iam.model.Policy;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsiampolicy")
public class IamPolicy
extends AWSResource {
    protected static final String TABLE_NAME = "awsiampolicy";
    public static final String RESOURCE_TYPE = "AWS::IAM::Policy";

    public IamPolicy() {
        this.resourceType = RESOURCE_TYPE;
    }

    public IamPolicy(String accountId, String region, Policy policy) {
        this.arn = policy.arn();
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = policy.policyId();
        this.resourceName = policy.policyName();
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = policy.createDate();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{policy});
    }
}

