/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.utils;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import io.openraven.magpie.data.exception.MissingEntityTypeException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class EntityTypeResolver
extends TypeIdResolverBase {
    private JavaType baseType;
    private Map<String, Class<?>> typeMap = new HashMap();

    public void init(JavaType javaType) {
        this.baseType = javaType;
        Class rawClass = this.baseType.getRawClass();
        Set<Class<?>> subTypes = EntityTypeResolver.getSubClasses(rawClass);
        subTypes.forEach(type -> {
            try {
                Field resourceTypeField = type.getDeclaredField("RESOURCE_TYPE");
                String key = String.valueOf(resourceTypeField.get(null));
                if (this.typeMap.containsKey(key)) {
                    throw new IllegalStateException("RESOURCE_TYPE:  \"" + key + "\" already exists.");
                }
                this.typeMap.put(key, (Class<?>)type);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException(String.format("Entity %s does not declare RESOURCE_TYPE constant", type.getName()));
            }
        });
    }

    public String idFromValue(Object o) {
        return this.idFromValueAndType(o, o.getClass());
    }

    public String idFromValueAndType(Object o, Class<?> aClass) {
        return null;
    }

    public JavaType typeFromId(DatabindContext context, String id) throws MissingEntityTypeException {
        if (this.typeMap.containsKey(id)) {
            return context.constructSpecializedType(this.baseType, this.typeMap.get(id));
        }
        throw new MissingEntityTypeException("Cannot find class for type id \"" + id + "\"");
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public static Set<Class<?>> getSubClasses(Class<?> rawClass) {
        Reflections reflections = new Reflections(rawClass.getPackageName(), new Scanner[0]);
        Set abstractSubResources = reflections.getSubTypesOf(rawClass);
        return abstractSubResources.stream().map(resourceClass -> reflections.getSubTypesOf(resourceClass)).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

