/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.rds;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsrdsdbinstance")
public class RDSInstance
extends AWSResource {
    protected static final String TABLE_NAME = "awsrdsdbinstance";
    public static final String RESOURCE_TYPE = "AWS::RDS::DBInstance";

    public RDSInstance() {
        this.resourceType = RESOURCE_TYPE;
    }

    public RDSInstance(String account, String regionId, DBInstance resource) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = resource.dbInstanceArn();
        this.resourceId = resource.dbInstanceArn();
        this.resourceName = resource.dbInstanceIdentifier();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{resource});
        this.createdIso = resource.instanceCreateTime();
    }
}

