/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.lakeformation;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.lakeformation.model.ResourceInfo;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awslakeformationresource")
public class LakeFormationResource
extends AWSResource {
    protected static final String TABLE_NAME = "awslakeformationresource";
    public static final String RESOURCE_TYPE = "AWS::LakeFormation::Resource";

    public LakeFormationResource() {
        this.resourceType = RESOURCE_TYPE;
    }

    public LakeFormationResource(String account, String regionId, ResourceInfo resource) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = resource.resourceArn();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{resource});
        this.resourceType = RESOURCE_TYPE;
        this.updatedIso = resource.lastModified();
    }
}

