/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.elbv2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awselasticloadbalancingv2loadbalancer")
public class ElasticLoadBalancingV2LoadBalancer
extends AWSResource {
    protected static final String TABLE_NAME = "awselasticloadbalancingv2loadbalancer";
    public static final String RESOURCE_TYPE = "AWS::ElasticLoadBalancingV2::LoadBalancer";

    public ElasticLoadBalancingV2LoadBalancer() {
        this.resourceType = RESOURCE_TYPE;
    }

    public ElasticLoadBalancingV2LoadBalancer(LoadBalancer loadBalancer, String region, String accountId) {
        this.resourceName = loadBalancer.dnsName();
        this.resourceId = loadBalancer.loadBalancerName();
        this.awsRegion = region;
        this.awsAccountId = accountId;
        this.resourceType = RESOURCE_TYPE;
        this.arn = loadBalancer.loadBalancerArn();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{loadBalancer});
        this.createdIso = loadBalancer.createdTime();
    }
}

