/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ecs;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.ecs.model.Cluster;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsecscluster")
public class EcsCluster
extends AWSResource {
    protected static final String TABLE_NAME = "awsecscluster";
    public static final String RESOURCE_TYPE = "AWS::ECS::Cluster";

    public EcsCluster() {
        this.resourceType = RESOURCE_TYPE;
    }

    public EcsCluster(String account, String regionId, Cluster cluster) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = cluster.clusterArn();
        this.resourceName = cluster.clusterName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{cluster});
        this.resourceType = RESOURCE_TYPE;
    }
}

