/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.eb;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescription;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awselasticbeanstalk")
public class EbEnvironment
extends AWSResource {
    protected static final String TABLE_NAME = "awselasticbeanstalk";
    public static final String RESOURCE_TYPE = "AWS::ElasticBeanstalk";

    public EbEnvironment() {
        this.resourceType = RESOURCE_TYPE;
    }

    public EbEnvironment(String account, String regionId, EnvironmentDescription cluster) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = cluster.environmentArn();
        this.resourceName = cluster.environmentName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{cluster});
        this.resourceType = RESOURCE_TYPE;
    }
}

