/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.backup;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.backup.model.BackupVaultListMember;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsbackupbackupvault")
public class BackupVault
extends AWSResource {
    protected static final String TABLE_NAME = "awsbackupbackupvault";
    public static final String RESOURCE_TYPE = "AWS::Backup::BackupVault";

    public BackupVault() {
        this.resourceType = RESOURCE_TYPE;
    }

    public BackupVault(String accountId, String region, BackupVaultListMember backupVaultListMember) {
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{backupVaultListMember});
        this.resourceType = RESOURCE_TYPE;
        this.arn = backupVaultListMember.backupVaultArn();
        this.resourceName = backupVaultListMember.backupVaultName();
        this.resourceId = backupVaultListMember.backupVaultName();
        this.createdIso = backupVaultListMember.creationDate();
    }
}

