/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.cloudsearch;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatus;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awscloudsearchdomain")
public class CloudSearchDomain
extends AWSResource {
    protected static final String TABLE_NAME = "awscloudsearchdomain";
    public static final String RESOURCE_TYPE = "AWS::CloudSearch::Domain";

    public CloudSearchDomain() {
        this.resourceType = RESOURCE_TYPE;
    }

    public CloudSearchDomain(String account, String regionId, DomainStatus domain) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = domain.arn();
        this.resourceId = domain.domainId();
        this.resourceName = domain.domainName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{domain});
        this.resourceType = RESOURCE_TYPE;
    }
}

