/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.redshift;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsredshiftcluster")
public class RedshiftCluster
extends AWSResource {
    protected static final String TABLE_NAME = "awsredshiftcluster";
    public static final String RESOURCE_TYPE = "AWS::Redshift::Cluster";

    public RedshiftCluster() {
        this.resourceType = RESOURCE_TYPE;
    }

    public RedshiftCluster(String regionId, Cluster cluster, String accountId) {
        this.awsRegion = regionId;
        this.resourceType = RESOURCE_TYPE;
        this.resourceId = cluster.clusterIdentifier();
        this.arn = String.format("arn:aws:redshift:%s:%s:cluster:%s", regionId, accountId, cluster.clusterIdentifier());
        this.resourceName = cluster.dbName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{cluster});
        this.awsAccountId = accountId;
        this.createdIso = cluster.clusterCreateTime();
    }
}

