/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.glacier;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import java.time.Instant;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsglaciervault")
public class GlacierVault
extends AWSResource {
    protected static final String TABLE_NAME = "awsglaciervault";
    public static final String RESOURCE_TYPE = "AWS::Glacier::Vault";

    public GlacierVault() {
        this.resourceType = RESOURCE_TYPE;
    }

    public GlacierVault(String regionId, String accountId, DescribeVaultOutput vault) {
        this.awsRegion = regionId;
        this.awsAccountId = accountId;
        this.arn = vault.vaultARN();
        this.resourceName = vault.vaultName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{vault});
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = Instant.parse(vault.creationDate());
        this.updatedIso = Instant.parse(vault.lastInventoryDate());
    }
}

