/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.gcp;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import io.openraven.magpie.data.utils.EntityTypeResolver;
import io.openraven.magpie.data.utils.JsonConverter;
import java.time.Instant;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="resourceType")
@JsonTypeIdResolver(value=EntityTypeResolver.class)
@Access(value=AccessType.FIELD)
@MappedSuperclass
public class GCPResource {
    @Id
    @Column(name="documentid", columnDefinition="TEXT", nullable=false, unique=true)
    public String documentId;
    @Column(name="assetid", columnDefinition="TEXT")
    public String assetId;
    @Column(name="resourcename", columnDefinition="TEXT")
    public String resourceName;
    @Column(name="resourceid", columnDefinition="TEXT")
    public String resourceId;
    @Column(name="resourcetype", columnDefinition="TEXT", updatable=false)
    public String resourceType;
    @Column(name="projectid", columnDefinition="TEXT")
    public String projectId;
    @Column(name="gcpaccountid", columnDefinition="TEXT")
    public String gcpAccountId;
    @Column(name="creatediso", columnDefinition="TIMESTAMPTZ")
    public Instant createdIso;
    @Column(name="updatediso", columnDefinition="TIMESTAMPTZ")
    public Instant updatedIso = Instant.now();
    @Column(name="discoverysessionid", columnDefinition="TEXT")
    public String discoverySessionId;
    @Transient
    public Long maxSizeInBytes = null;
    @Transient
    public Long sizeInBytes = null;
    @Column(name="configuration", columnDefinition="JSONB")
    @Convert(converter=JsonConverter.class)
    public JsonNode configuration;
    @Column(name="supplementaryconfiguration", columnDefinition="JSONB")
    @Convert(converter=JsonConverter.class)
    public JsonNode supplementaryConfiguration;
    @Column(name="tags", columnDefinition="JSONB")
    @Convert(converter=JsonConverter.class)
    public JsonNode tags;
    @Column(name="discoverymeta", columnDefinition="JSONB")
    @Convert(converter=JsonConverter.class)
    public JsonNode discoveryMeta;

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getGcpAccountId() {
        return this.gcpAccountId;
    }

    public void setGcpAccountId(String gcpAccountId) {
        this.gcpAccountId = gcpAccountId;
    }

    public Instant getCreatedIso() {
        return this.createdIso;
    }

    public void setCreatedIso(Instant createdIso) {
        this.createdIso = createdIso;
    }

    public Instant getUpdatedIso() {
        return this.updatedIso;
    }

    public void setUpdatedIso(Instant updatedIso) {
        this.updatedIso = updatedIso;
    }

    public String getDiscoverySessionId() {
        return this.discoverySessionId;
    }

    public void setDiscoverySessionId(String discoverySessionId) {
        this.discoverySessionId = discoverySessionId;
    }

    public Long getMaxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    public void setMaxSizeInBytes(Long maxSizeInBytes) {
        this.maxSizeInBytes = maxSizeInBytes;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    public JsonNode getSupplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public void setSupplementaryConfiguration(JsonNode supplementaryConfiguration) {
        this.supplementaryConfiguration = supplementaryConfiguration;
    }

    public JsonNode getTags() {
        return this.tags;
    }

    public void setTags(JsonNode tags) {
        this.tags = tags;
    }

    public JsonNode getDiscoveryMeta() {
        return this.discoveryMeta;
    }

    public void setDiscoveryMeta(JsonNode discoveryMeta) {
        this.discoveryMeta = discoveryMeta;
    }
}

