/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2storage;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.ec2.model.Volume;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2volume")
public class EC2Volume
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2volume";
    public static final String RESOURCE_TYPE = "AWS::EC2:Volume";

    public EC2Volume() {
        this.resourceType = RESOURCE_TYPE;
    }

    public EC2Volume(String accountId, String region, Volume volume) {
        this.arn = String.format("arn:aws:ec2:%s:%s:volume/%s", region, accountId, volume.volumeId());
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = volume.volumeId();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{volume});
    }
}

