/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.cspm.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.core.config.ConfigException;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.config.PluginConfig;
import io.openraven.magpie.core.cspm.analysis.IgnoredRule;
import io.openraven.magpie.core.cspm.analysis.ScanResults;
import io.openraven.magpie.core.cspm.analysis.Violation;
import io.openraven.magpie.core.cspm.model.Policy;
import io.openraven.magpie.core.cspm.model.PolicyContext;
import io.openraven.magpie.core.cspm.model.Rule;
import io.openraven.magpie.core.cspm.services.PolicyAnalyzerService;
import io.openraven.magpie.plugins.persist.AssetsRepo;
import io.openraven.magpie.plugins.persist.PersistConfig;
import io.openraven.magpie.plugins.persist.impl.HibernateAssetsRepoImpl;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.google.common.base.Strings;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyAnalyzerServiceImpl
implements PolicyAnalyzerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyAnalyzerServiceImpl.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private AssetsRepo assetsRepo;

    @Override
    public void init(MagpieConfig config) {
        PluginConfig rawPersistConfig = config.getPlugins().get("magpie.persist");
        if (rawPersistConfig == null) {
            throw new ConfigException(String.format("Config file does not contain %s configuration", "magpie.persist"));
        }
        try {
            PersistConfig persistConfig = (PersistConfig)MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(rawPersistConfig.getConfig()), PersistConfig.class);
            this.assetsRepo = new HibernateAssetsRepoImpl(persistConfig);
        }
        catch (JsonProcessingException e) {
            throw new ConfigException("Cannot instantiate PersistConfig while initializing PolicyAnalyzerService", e);
        }
    }

    @Override
    public ScanResults analyze(List<PolicyContext> policyContexts) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        ArrayList<IgnoredRule> ignoredRules = new ArrayList<IgnoredRule>();
        ArrayList<Policy> policies = new ArrayList<Policy>();
        policyContexts.forEach(policyContext -> {
            Policy policy = policyContext.getPolicy();
            this.processPolicy(policy, violations, ignoredRules);
            policies.add(policy);
        });
        return new ScanResults(policies, violations, ignoredRules);
    }

    private void processPolicy(Policy policy, List<Violation> policyViolations, List<IgnoredRule> policyIgnoredRules) {
        if (!policy.isEnabled()) {
            LOGGER.info("Policy '{}' disabled", (Object)policy.getName());
            return;
        }
        if (!this.cloudProviderAssetsAvailable(policy)) {
            LOGGER.warn("No assets found for cloudProvider: {}, policy: {}", (Object)policy.getCloudProvider(), (Object)policy.getName());
            return;
        }
        LOGGER.info("Analyzing policy - {}", (Object)policy.getName());
        policy.getRules().forEach(rule -> this.executeRule(policyViolations, policyIgnoredRules, policy, (Rule)rule));
    }

    private boolean cloudProviderAssetsAvailable(Policy policy) {
        BigInteger compareTo;
        String provider = Strings.isNullOrEmpty((String)policy.getCloudProvider()) ? "" : policy.getCloudProvider().toLowerCase(Locale.ROOT);
        List data = this.assetsRepo.queryNative("select count(*) from magpie.%provider%".replace("%provider%", provider));
        Object count = ((Map)data.get(0)).get("count");
        if (count instanceof BigInteger) {
            compareTo = (BigInteger)count;
        } else if (count instanceof Long) {
            compareTo = BigInteger.valueOf((Long)count);
        } else {
            throw new UnsupportedOperationException();
        }
        return BigInteger.ZERO.compareTo(compareTo) < 0;
    }

    protected void executeRule(List<Violation> policyViolations, List<IgnoredRule> policyIgnoredRules, Policy policy, Rule rule) {
        if (!rule.isEnabled()) {
            policyIgnoredRules.add(new IgnoredRule(policy, rule, IgnoredRule.IgnoredReason.DISABLED));
            LOGGER.info("Rule '{}' disabled", (Object)rule.getName());
            return;
        }
        if (rule.isManualControl()) {
            policyIgnoredRules.add(new IgnoredRule(policy, rule, IgnoredRule.IgnoredReason.MANUAL_CONTROL));
            LOGGER.info("Rule not analyzed (manually controlled) - {}", (Object)rule.getName());
            return;
        }
        List<String> missingAssets = this.checkForMissingAssets(rule.getSql());
        if (!missingAssets.isEmpty()) {
            policyIgnoredRules.add(new IgnoredRule(policy, rule, IgnoredRule.IgnoredReason.MISSING_ASSET));
            LOGGER.info("Missing assets for analyzing the rule, ignoring. [assets={}, rule={}]", missingAssets, (Object)rule.getName());
            return;
        }
        LOGGER.info("Analyzing rule - {}", (Object)rule.getName());
        LocalDateTime evaluatedAt = LocalDateTime.now();
        List<Map<String, Object>> results = this.assetsRepo.queryNative(rule.getSql());
        StringWriter evalErr = new StringWriter();
        if (!Optional.ofNullable(rule.getEval()).orElse("").isEmpty()) {
            try {
                results = this.evaluate(rule, results);
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't run eval code", (Throwable)e);
                evalErr.append(e.getMessage());
            }
        }
        results.forEach(result -> {
            Violation violation = new Violation();
            violation.setPolicy(policy);
            violation.setRule(rule);
            violation.setAssetId(result.get("assetid").toString());
            violation.setInfo(rule.getDescription());
            violation.setError(evalErr.toString());
            violation.setEvaluatedAt(evaluatedAt);
            policyViolations.add(violation);
        });
    }

    private List<String> checkForMissingAssets(String sql) {
        String sqlNoWhitespaces = sql.replaceAll("\\s+", "");
        String resourceTypeSearch = "resourcetype='";
        ArrayList<String> resourceTypes = new ArrayList<String>();
        int index = 0;
        while (index != -1) {
            if ((index = sqlNoWhitespaces.indexOf(resourceTypeSearch, index)) == -1) continue;
            int resourceTypeEndIndex = sqlNoWhitespaces.indexOf(39, index + resourceTypeSearch.length());
            String resourceType2 = sqlNoWhitespaces.substring(index + resourceTypeSearch.length(), resourceTypeEndIndex);
            resourceTypes.add(resourceType2);
            ++index;
        }
        ArrayList<String> missingAssets = new ArrayList<String>();
        resourceTypes.forEach(resourceType -> {
            if (this.assetsRepo.getAssetCount(resourceType) == 0L) {
                missingAssets.add((String)resourceType);
            }
        });
        return missingAssets;
    }

    @Override
    public List<Map<String, Object>> evaluate(Rule rule, Object resultSet) throws Exception {
        ArrayList<Map<String, Object>> results;
        block8: {
            results = new ArrayList<Map<String, Object>>();
            StringWriter output = new StringWriter();
            try (PythonInterpreter pyInterp = new PythonInterpreter();){
                pyInterp.setOut((Writer)output);
                pyInterp.exec(rule.getEval());
                pyInterp.set("resultset", resultSet);
                PyObject v = pyInterp.eval("evaluate(resultset)");
                if (v instanceof PyList) {
                    ((PyList)v).stream().forEach(item -> {
                        if (item instanceof PyDictionary) {
                            PyDictionary dict = (PyDictionary)item;
                            HashMap map = new HashMap();
                            dict.keySet().forEach(k -> map.put(k.toString(), dict.get(k)));
                            results.add(map);
                        } else {
                            LOGGER.warn("{} returned an invalid value, found {} but expected a dictionary", (Object)rule.getName(), (Object)item.getClass().getName());
                        }
                    });
                    break block8;
                }
                throw new RuntimeException("Eval block returned an illegal value. Expected a Python list but found " + v.getClass().getName());
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        return results;
    }
}

