/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.plugins;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.MagpiePlugin;
import io.openraven.magpie.core.config.ConfigException;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.config.PluginConfig;
import io.openraven.magpie.core.plugins.PluginLoaderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.python.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private final MagpieConfig config;
    private final Map<Class<? extends MagpiePlugin>, List<MagpiePlugin<?>>> plugins = new HashMap();

    public PluginManager(MagpieConfig config) {
        this.config = config;
    }

    public void loadPlugins(List<Class<? extends MagpiePlugin>> pluginClasses) {
        AtomicLong pluginsFound = new AtomicLong();
        pluginClasses.forEach(c -> {
            ServiceLoader loader = ServiceLoader.load(c);
            long count = loader.stream().count();
            LOGGER.debug("Found {} {} plugin(s) via the classpath", (Object)c.getSimpleName(), (Object)count);
            pluginsFound.addAndGet(count);
            loader.stream().forEach(svc -> {
                MagpiePlugin plugin = (MagpiePlugin)svc.get();
                try {
                    Class configType = plugin.configType();
                    PluginConfig pluginConfigParent = this.config.getPlugins().get(plugin.id());
                    if (pluginConfigParent == null) {
                        LOGGER.debug("No configuration found for {}, ignoring.", (Object)plugin.id());
                    } else if (!pluginConfigParent.isEnabled()) {
                        LOGGER.debug("{} found but is disabled via config. Ignoring}", (Object)plugin.id());
                    } else {
                        Object pluginConfig = PluginManager.buildPluginConfig(plugin.id(), configType, pluginConfigParent.getConfig());
                        plugin.init(pluginConfig, LoggerFactory.getLogger(plugin.getClass()));
                        List pluginList = this.plugins.getOrDefault(c, new ArrayList());
                        pluginList.add(plugin);
                        this.plugins.put((Class<MagpiePlugin>)c, pluginList);
                        LOGGER.debug("Loaded {}", (Object)plugin.id());
                    }
                }
                catch (Exception ex) {
                    throw new PluginLoaderException(ex);
                }
            });
        });
        if (pluginsFound.get() == 0L) {
            throw new ConfigException("No plugins found");
        }
    }

    public static Object buildPluginConfig(String pluginId, Class<?> configType, Object config) throws JsonProcessingException {
        if (configType == null || "Void".equals(configType.getSimpleName())) {
            return null;
        }
        if (config == null) {
            try {
                LOGGER.debug("No config section found for {}:{}, attempting to instantiate a default", (Object)pluginId, (Object)configType.getName());
                Optional<Constructor> constructor = Arrays.stream(configType.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).findFirst();
                if (constructor.isEmpty()) {
                    LOGGER.warn("No plugin configuration found for {} and no suitable constructor found to create a default.", (Object)pluginId);
                    return null;
                }
                return constructor.get().newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new ConfigException(String.format("Cannot instantiate config for %s with type %s", pluginId, configType.getName()), ex);
            }
        }
        HashSet pluginList = Sets.newHashSet((Object[])new String[]{"magpie.aws.discovery", "magpie.persist", "PolicyService"});
        if (pluginList.contains(pluginId)) {
            return MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(config), configType);
        }
        return config;
    }

    public List<MagpiePlugin<?>> byType(Class<? extends MagpiePlugin> clazz) {
        List<MagpiePlugin<?>> list = this.plugins.get(clazz);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public Optional<MagpiePlugin<?>> byId(String id) {
        List matches = this.plugins.values().stream().flatMap(Collection::stream).filter(plugin -> plugin.id().equals(id)).collect(Collectors.toList());
        assert (matches.size() <= 1);
        return matches.isEmpty() ? Optional.empty() : Optional.of((MagpiePlugin)matches.get(0));
    }
}

