/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.openraven.magpie.core.config.ConfigException;
import io.openraven.magpie.core.config.MagpieConfig;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final Pattern ENV_VAR_OVERRIDE_PATTERN = Pattern.compile("MAGPIE_CONFIG.*");

    private static Map<JsonPointer, JsonNode> toPointers(ObjectNode node) {
        LinkedHashMap<JsonPointer, JsonNode> map = new LinkedHashMap<JsonPointer, JsonNode>();
        Iterator iter = node.fields();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            map.put(JsonPointer.compile((String)((String)entry.getKey())), (JsonNode)entry.getValue());
        }
        return map;
    }

    static Map<JsonPointer, JsonNode> envOverrides(Map<String, String> env) {
        LinkedHashMap<JsonPointer, JsonNode> map = new LinkedHashMap<JsonPointer, JsonNode>();
        env.keySet().stream().filter(e -> ENV_VAR_OVERRIDE_PATTERN.matcher((CharSequence)e).matches()).sorted().forEach(e -> {
            JsonNode value = null;
            try {
                value = MAPPER.readTree((String)env.get(e));
            }
            catch (JsonProcessingException ex) {
                throw new ConfigException("Couldn't parse environmental variable " + e, ex);
            }
            if (value.isArray()) {
                ArrayNode node = (ArrayNode)value;
                node.forEach(child -> {
                    if (!child.isObject()) {
                        throw new ConfigException(String.format("Couldn't parse environment override.  Values for %s must be a JSON array of the form [{<jsonPointer>: <value>}]", e));
                    }
                    map.putAll(ConfigUtils.toPointers((ObjectNode)child));
                });
            } else if (value.isObject()) {
                map.putAll(ConfigUtils.toPointers((ObjectNode)value));
            } else {
                throw new ConfigException(String.format("Couldn't parse environment override.  Value for %s must be a JSON array or JSON object.", e));
            }
        });
        return map;
    }

    public static MagpieConfig merge(MagpieConfig config, Map<String, String> env) throws JsonProcessingException {
        Map<JsonPointer, JsonNode> overrides = ConfigUtils.envOverrides(env);
        ObjectNode configNode = (ObjectNode)MAPPER.valueToTree((Object)config);
        overrides.forEach((key, value) -> {
            JsonPointer parentName = key.head();
            JsonNode overriddenNode = configNode.at(key);
            if (overriddenNode.isMissingNode()) {
                LOGGER.warn("Cannot override {}, no configuration with that path exists", key);
            } else {
                String leafName = key.last().toString().replaceFirst("/", "");
                ObjectNode parentNode = (ObjectNode)configNode.at(parentName);
                LOGGER.debug("Replacing {} with value {}", key, (Object)value.toPrettyString());
                parentNode.replace(leafName, value);
            }
        });
        return (MagpieConfig)MAPPER.treeToValue((TreeNode)configNode, MagpieConfig.class);
    }

    private ConfigUtils() {
    }
}

