/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.layers;

import io.openraven.magpie.api.IntermediatePlugin;
import io.openraven.magpie.api.MagpieEnvelope;
import io.openraven.magpie.api.MagpiePlugin;
import io.openraven.magpie.core.fifos.FifoDequeue;
import io.openraven.magpie.core.fifos.FifoException;
import io.openraven.magpie.core.fifos.FifoQueue;
import io.openraven.magpie.core.layers.Layer;
import io.openraven.magpie.core.layers.LayerType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateLayer
implements Layer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateLayer.class);
    private final FifoDequeue dequeue;
    private final Collection<IntermediatePlugin> plugins;
    private final FifoQueue queue;
    private final String name;

    public IntermediateLayer(String name, FifoDequeue dequeue, Collection<IntermediatePlugin> plugins, FifoQueue queue) {
        this.dequeue = dequeue;
        this.plugins = plugins;
        this.queue = queue;
        this.name = name;
    }

    @Override
    public void exec() throws FifoException {
        Optional<MagpieEnvelope> opt = this.dequeue.poll();
        if (opt.isEmpty()) {
            return;
        }
        MagpieEnvelope env = opt.get();
        List pluginPath = env.getPluginPath();
        String lastPlugin = pluginPath.isEmpty() ? null : (String)pluginPath.get(pluginPath.size() - 1);
        this.plugins.forEach(p -> {
            try {
                p.accept(env, this::emit);
            }
            catch (Exception ex) {
                LOGGER.warn("Plugin exception: {}", (Object)p.id(), (Object)ex);
            }
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void emit(MagpieEnvelope env) {
        try {
            this.queue.add(env);
        }
        catch (FifoException e) {
            LOGGER.warn("Emitter exception", (Throwable)e);
        }
    }

    @Override
    public LayerType getType() {
        return LayerType.INTERMEDIATE;
    }

    @Override
    public void shutdown() {
        this.plugins.forEach(MagpiePlugin::shutdown);
    }
}

