/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.cspm.services;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.openraven.magpie.api.MagpiePlugin;
import io.openraven.magpie.api.PolicyOutputPlugin;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.cspm.analysis.ScanMetadata;
import io.openraven.magpie.core.cspm.analysis.ScanResults;
import io.openraven.magpie.core.cspm.model.PolicyContext;
import io.openraven.magpie.core.cspm.services.CspmFacade;
import io.openraven.magpie.core.cspm.services.PolicyAcquisitionServiceImpl;
import io.openraven.magpie.core.cspm.services.PolicyAnalyzerServiceImpl;
import io.openraven.magpie.core.plugins.PluginManager;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CspmFacadeImpl
implements CspmFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(CspmFacadeImpl.class);
    private static final List<Class<? extends MagpiePlugin>> OUTPUT_PLUGIN_CLASSES = List.of(PolicyOutputPlugin.class);
    private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    @Override
    public void analyze(MagpieConfig config) {
        Instant start = Instant.now();
        PolicyAcquisitionServiceImpl policyAcquisitionService = new PolicyAcquisitionServiceImpl();
        policyAcquisitionService.init(config);
        List<PolicyContext> policies = policyAcquisitionService.loadPolicies();
        PolicyAnalyzerServiceImpl analyzerService = new PolicyAnalyzerServiceImpl();
        analyzerService.init(config);
        try {
            ScanResults scanResults = analyzerService.analyze(policies);
            Duration scanDuration = Duration.between(start, Instant.now());
            ScanMetadata scanMetadata = new ScanMetadata(Date.from(start), scanDuration);
            scanResults.setScanMetadata(scanMetadata);
            PluginManager policyPluginManager = new PluginManager(config);
            policyPluginManager.loadPlugins(OUTPUT_PLUGIN_CLASSES);
            List<MagpiePlugin<?>> outputPlugins = policyPluginManager.byType(PolicyOutputPlugin.class);
            outputPlugins.forEach(outputPlugin -> {
                LOGGER.debug("Executing output plugin : {}", outputPlugin.getClass());
                ((PolicyOutputPlugin)outputPlugin).generateReport((ObjectNode)this.mapper.valueToTree((Object)scanResults));
            });
            outputPlugins.forEach(MagpiePlugin::shutdown);
        }
        catch (Exception e) {
            LOGGER.error("Analyze error: {}", (Object)e.getMessage(), (Object)e);
        }
        LOGGER.info("Policy analysis completed in {}", (Object)CspmFacadeImpl.humanReadableFormat(Duration.between(start, Instant.now())));
    }

    private static String humanReadableFormat(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }
}

